﻿var importSurveyTemplate = {
    context: $(".v-import"),
    importContext: $(".v-import"),
    allvalidations: { "showValidationQuestionnaireFile": false, "showValidationTranslationFile": false, "showValidationLookAndFeelFile": false },
    initializeAutoCompletes: function () {

        importSurveyTemplate.context.on("click", "#importButton", function () {
            a4.parent().mySurveyTemplates.showBusyBox();
        });
    },
    bindEvents: function () {

        this.importContext.on("click", ".h-clearFile", function () {
            var container = $(this).closest(".v-section");
            var fileUploadInput = $(".h-fileUpload", container);

            fileUploadInput.replaceWith($("<input />", { "type": "file", "id": fileUploadInput.attr("id"), "name": fileUploadInput.attr("name"), "class": fileUploadInput.attr("class"), "style": fileUploadInput.attr("style") }));

            $(this).hide();
            $(".v-sectionOptions", container).hide();

            var filesToUpload = _.compact($(".h-fileUpload:not('.h-jsonUpload')", importSurveyTemplate.context).map(function () { return $(this).val(); }).toArray());
            if (filesToUpload.length === 0) {
                $(".h-fileUpload", importSurveyTemplate.context).prop("disabled", false);
            }

            $("#validate" + fileUploadInput.attr("name")).addClass("d-none");
        });

        this.importContext.on("change", ".h-jsonUpload", function () {
            if ($(this).val().length !== 0)
                $(".h-fileUpload:not('.h-jsonUpload')", importSurveyTemplate.context).prop("disabled", true);
        });

        this.importContext.on("change", ".h-fileUpload:not('.h-jsonUpload')", function () {
            if ($(this).val().length !== 0)
                $(".h-jsonUpload", importSurveyTemplate.context).prop("disabled", true);
        });

        this.importContext.on("change", ".h-fileUpload", function () {
            if ($(this).val().length !== 0) {
                var ext = $(this).val().split('.').pop().toLowerCase();
                var container = $(this).closest(".v-section");
                $(".v-importResult", container).hide();
                $(".error", container).hide();
                $(".h-clearFile", container).show();
                if ($.inArray(ext, ['xls', 'xlsx']) == -1) {
                    $("#validate" + this.name).text(importvalidationResource.InvalidFileType);
                    $("#validate" + this.name).removeClass("d-none");
                    importSurveyTemplate.allvalidations["showValidation" + this.name] = true;
                } else {
                    $("#validate" + this.name).addClass("d-none");
                    var file = this.files[0];
                    ValidationUploadFile(file, this.name);
                }
            }
        });

        this.importContext.on("click", "#importButton", function () {
            if (importSurveyTemplate.allvalidations.showValidationQuestionnaireFile || importSurveyTemplate.allvalidations.showValidationTranslationFile || importSurveyTemplate.allvalidations.showValidationLookAndFeelFile || document.getElementById("QuestionnaireFile").files.length == 0 || document.getElementById("TranslationFile").files.length == 0 || document.getElementById("LookAndFeelFile").files.length == 0) {
                if (document.getElementById("QuestionnaireFile").files.length == 0) {
                    $("#validateQuestionnaireFile").text(importvalidationResource.FileRequired);
                    $("#validateQuestionnaireFile").removeClass("d-none");
                }
                if (document.getElementById("TranslationFile").files.length == 0) {
                    $("#validateTranslationFile").text(importvalidationResource.FileRequired);
                    $("#validateTranslationFile").removeClass("d-none");
                }
                if (document.getElementById("LookAndFeelFile").files.length == 0) {
                    $("#validateLookAndFeelFile").text(importvalidationResource.FileRequired);
                    $("#validateLookAndFeelFile").removeClass("d-none");
                }
                a4.parent().mySurveyTemplates.hideBusyBox();
                return false;
            }
        });
    }
}

$(document).ready(function () {
    a4.parent().mySurveyTemplates.hideBusyBox();
    importSurveyTemplate.initializeAutoCompletes();
    importSurveyTemplate.bindEvents();
});

async function ValidationUploadFile(file, name) {
    var reader = new FileReader();
    reader.readAsArrayBuffer(file);
    reader.onload = await function (e) {
        var data = e.target.result;
        var workbook = XLSX.read(data, {
            type: 'binary'
        });
        var firstSheetName = workbook.SheetNames[0];
        var jsonData = XLSX.utils.sheet_to_json(workbook.Sheets[firstSheetName]);
        var columnSet = [];
        for (var key in jsonData[0]) {
            if (jsonData[0].hasOwnProperty(key)) {
                if ($.inArray(key, columnSet) == -1) {
                    columnSet.push(key);
                }
            }
        }
        showValidation(columnSet, name);
    }
}

async function showValidation(columnSet, name) {
    var showDynamicValidation = false;
    var validationMessage = "";
    var requiredcolumns = [];
    if (name == "QuestionnaireFile") {
        validationMessage = importvalidationResource.InvalidFileFormatForQuestionnaire;
        requiredcolumns = ["Item", "Name", "Text", "Type", "Setting Value"];
    }
    else if (name == "TranslationFile") {
        validationMessage = importvalidationResource.InvalidFileFormatForTranslation;
        requiredcolumns = ["Item", "Property", "Id"];
    }
    else if (name == "LookAndFeelFile") {
        validationMessage = importvalidationResource.InvalidFileFormat;
        requiredcolumns = ["Theme", "ThemeElement", "Field", "Value"];
    }
    if (requiredcolumns.length > 0) {
        for (var column in requiredcolumns) {
            if (columnSet.length === 0 || !columnSet.includes(requiredcolumns[column])) {
                showDynamicValidation = true;
                break;
            }
        }

        if (showDynamicValidation) {
            importSurveyTemplate.allvalidations["showValidation" + name] = true;
            $("#validate" + name).text(validationMessage);
            $("#validate" + name).removeClass("d-none");
        } else {
            importSurveyTemplate.allvalidations["showValidation" + name] = false;
        }
    }
}
